//
//  Capturing_Thumbnails_from_a_Video_FileViewController.m
//  Capturing Thumbnails from a Video File
//
//  Created by Vandad Nahavandipoor on 16/07/2011.
//  Copyright 2011 Pixolity Ltd. All rights reserved.
//

#import "Capturing_Thumbnails_from_a_Video_FileViewController.h"

@interface Capturing_Thumbnails_from_a_Video_FileViewController(Private)
- (void) startPlayingVideo:(id)paramSender;
- (void) stopPlayingVideo:(id)paramSender;
@end

@implementation Capturing_Thumbnails_from_a_Video_FileViewController

@synthesize moviePlayer;
@synthesize playButton;

- (void) videoHasFinishedPlaying:(NSNotification *)paramNotification{
  
  /* Określenie powodu zatrzymania działania odtwarzacza. */
  NSNumber *reason = 
  [paramNotification.userInfo
   valueForKey:MPMoviePlayerPlaybackDidFinishReasonUserInfoKey];
  
  if (reason != nil){
    NSInteger reasonAsInteger = [reason integerValue];
    
    switch (reasonAsInteger){
      case MPMovieFinishReasonPlaybackEnded:{
        /* Odtwarzanie treści wideo zakończyło się w zwykły sposób. */
        break;
      }
      case MPMovieFinishReasonPlaybackError:{
        /* Wystąpił błąd, więc przerwano odtwarzanie treści wideo. */
        break;
      }
      case MPMovieFinishReasonUserExited:{
        /* Użytkownik zakończył działanie odtwarzacza. */
        break;
      }
    }
    
    NSLog(@"Powód zakończenia działania = %ld", (long)reasonAsInteger);
    [self stopPlayingVideo:nil];
  } /* if (reason != nil){ */
  
}

- (void) videoThumbnailIsAvailable:(NSNotification *)paramNotification{
  
  MPMoviePlayerController *controller = [paramNotification object];
  
  if (controller != nil &&
      [controller isEqual:self.moviePlayer]){
    NSLog(@"Zrzut ekranu jest dostępny.");
    
    /* Pobranie zrzutu ekranu ze słownika userInfo. */
    UIImage *thumbnail = 
    [paramNotification.userInfo 
     objectForKey:MPMoviePlayerThumbnailImageKey];
    
    if (thumbnail != nil){
      /* Mamy zrzut ekranu i możemy go w tym miejscu wykorzystać. */
    }
  }
  
}

- (void) startPlayingVideo:(id)paramSender{
  
  /* Najpierw przygotowujemy adres URL pliku znajdującego się w aplikacji,
   który będzie odtworzony przez budowany odtwarzacz plików wideo. */
  NSBundle *mainBundle = [NSBundle mainBundle];
  
  NSString *urlAsString = [mainBundle pathForResource:@"Sample"
                                               ofType:@"m4v"];
  
  NSURL    *url = [NSURL fileURLWithPath:urlAsString];
  
  /* Jeżeli wcześniej udało się utworzyć odtwarzacz treści wideo,
   to w tym miejscu spróbujemy zatrzymać jego działanie. */
  if (self.moviePlayer != nil){
    [self stopPlayingVideo:nil];
  }
  
  /* Teraz tworzymy nowy odtwarzacz treści wideo, wykorzystując przygotowany wcześniej adres URL. */
  self.moviePlayer = [[MPMoviePlayerController alloc] initWithContentURL:url];
  
  if (self.moviePlayer != nil){
    
    /* Nasłuchujemy powiadomień wysyłanych przez odtwarzacz 
      po zakończeniu odtwarzania pliku z treścią. */
    [[NSNotificationCenter defaultCenter] 
     addObserver:self
     selector:@selector(videoHasFinishedPlaying:)
     name:MPMoviePlayerPlaybackDidFinishNotification
     object:self.moviePlayer];
    
    [[NSNotificationCenter defaultCenter]
     addObserver:self
     selector:@selector(videoThumbnailIsAvailable:)
     name:MPMoviePlayerThumbnailImageRequestDidFinishNotification
     object:self.moviePlayer];
    
    NSLog(@"Udało się utworzyć odtwarzacz treści wideo.");
    
    /* Skalujemy odtwarzacz wideo z zachowaniem odpowiednich proporcji. */
    self.moviePlayer.scalingMode = MPMovieScalingModeAspectFit;
    
    /* Rozpoczynamy odtwarzanie treści wideo w trybie pełnego ekranu. */
    [self.moviePlayer play];
    
    [self.view addSubview:self.moviePlayer.view];
    
    [self.moviePlayer setFullscreen:YES
                           animated:YES];
    
    /* Wykonanie zrzutu ekranu w trzeciej sekundzie odtwarzanej treści wideo. */
    NSNumber *thirdSecondThumbnail = [NSNumber numberWithFloat:3.0f];
    
    /* Istnieje możliwość przechwycenia dowolnej liczby klatek. 
      W omawianym przykładzie przechwytujemy tylko jedną. */
    NSArray  *requestedThumbnails = 
    [NSArray arrayWithObject:thirdSecondThumbnail];
    
    /* Zlecenie odtwarzaczowi treści wideo przechwycenia klatki. */
    [self.moviePlayer 
     requestThumbnailImagesAtTimes:requestedThumbnails
     timeOption:MPMovieTimeOptionExact];
    
  } else {
    NSLog(@"Nie udało się utworzyć odtwarzacza treści wideo.");
  }
  
}

- (void) stopPlayingVideo:(id)paramSender {
  
  if (self.moviePlayer != nil){
    
    [[NSNotificationCenter defaultCenter]
     removeObserver:self
     name:MPMoviePlayerPlaybackDidFinishNotification
     object:self.moviePlayer];
    
    [[NSNotificationCenter defaultCenter]
     removeObserver:self
     name:MPMoviePlayerThumbnailImageRequestDidFinishNotification
     object:self.moviePlayer];
    
    [self.moviePlayer stop];
    
    if ([self.moviePlayer.view.superview isEqual:self.view]){
      [self.moviePlayer.view removeFromSuperview];
    }
  }
  
}

- (void)viewDidLoad {
  [super viewDidLoad];
  
  self.view.backgroundColor = [UIColor whiteColor];
  
  self.playButton = [UIButton buttonWithType:UIButtonTypeRoundedRect];
  self.playButton.frame = CGRectMake(0.0f, 
                                     0.0f, 
                                     70.0f, 
                                     37.0f);
  self.playButton.center = self.view.center;
  
  self.playButton.autoresizingMask = 
    UIViewAutoresizingFlexibleTopMargin |
    UIViewAutoresizingFlexibleLeftMargin |
    UIViewAutoresizingFlexibleBottomMargin |
    UIViewAutoresizingFlexibleRightMargin;
  
  [self.playButton addTarget:self
                      action:@selector(startPlayingVideo:)
            forControlEvents:UIControlEventTouchUpInside];
  [self.playButton setTitle:@"Odtwórz"
                   forState:UIControlStateNormal];
  [self.view addSubview:self.playButton];
  
}

- (void) viewDidUnload{
  self.playButton = nil;
  [self stopPlayingVideo:nil];
  self.moviePlayer = nil;
  [super viewDidUnload];
}

- (BOOL)shouldAutorotateToInterfaceOrientation
:(UIInterfaceOrientation)interfaceOrientation{
  return YES;
}

@end

